<?php

    /**
    *
    * copyright (c) 2015-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * Classe statica che consente di stampare vari tipi di messaggi con bootstrap
    */

    class GeneratoreForm {
        
        /*
         * metodo che stampa un campo input di tipo text
         * prende in input i seguenti parametri:
         * 
         * $idCampo         -> id del campo input
         * $nome            -> id del campo input
         * $etichetta           -> label del campo input. Se la stringa passata contiene tag html verrà stampata
                               senza aggiungere codice, altrimenti la stringa verrà stampata dentro il tag <label></label>
         * $placeholder     -> contiene il valore da mettere nella proprietà placeholder del campo input
         * $valore          -> contiene il valore da mettere nella proprietà value
	  * $required        -> campo opzionale che consente di stabilire se il campo è obbligatorio oppure no. Se si vuole
	  *			   rendere quel campo obbligatorio bisogna scrivere required, altrimenti non è necessario impostare il parametro
         * $classeDivContenitore -> campo opzionale che permette di modificare il la classe del div contenitore del form
         *                          se non specificato, ha valore "form-line"
         */
        public static function stampaInputTestuale($idCampo,$nome,$etichetta,$placeholder, $valore, $required="", $mostraDivContenitore=true, $classeDivContenitore="form-line") {
        	if($mostraDivContenitore) {
		    echo"<div class=\"$classeDivContenitore\">";
        	}
        	
        	echo"<input type=\"text\" class=\"form-control\" id=\"$idCampo\" name=\"$nome\" value=\"$valore\" placeholder=\"$placeholder\" $required >";
        	if($etichetta!="") {
			if($etichetta != strip_tags($etichetta)) { // $etichetta contiene html
			    echo $etichetta;
			}
			else { // $etichetta non contiene html quindi fa solo domande
			    echo"<label for=\"$idCampo\" >$etichetta</label>";
			}
        	}
        	
        	if($mostraDivContenitore) {
		    echo"</div>";
        	}
	}
        
        /*
         * metodo che stampa una input di tipo textarea
         * prende in input i seguenti parametri:
         * 
         * $idCampo         -> id del campo input
         * $nome            -> id del campo input
         * $etichetta       -> label del campo input. Se la stringa passata contiene tag html verrà stampata
                               senza aggiungere codice, altrimenti la stringa verrà stampata dentro il tag <label></label>
         * righe	    -> il numero di righe della textarea
         * colonne	    -> il numero di colonnee della textarea
         * $placeholder     -> contiene il valore da mettere nella proprietà placeholder del campo input
         * $valore          -> contiene il valore da mettere nella proprietà value
	 * $required        -> campo opzionale che consente di stabilire se il campo è obbligatorio oppure no. Se si vuole
	 *			   rendere quel campo obbligatorio bisogna scrivere required, altrimenti non è necessario impostare il parametro
         * $classeDivContenitore -> campo opzionale che permette di modificare il la classe del div contenitore del form
         *                          se non specificato, ha valore "form-line"
         */
        public static function stampaAreaTesto($idCampo,$nome,$etichetta, $placeholder, $valore, $righe, $colonne, $required="", $classeDivContenitore="form-line") {
            echo"<div class=\"form-label-group\">";
                
                $stringaRighe = ($righe > 0) ? "rows=\"$righe\"" : "";
                $stringaColonne = ($colonne > 0) ? "cols=\"$righe\"" : "";
                
                echo"<textarea type=\"text\"  $stringaRighe $stringaColonne class=\"form-control\" id=\"$idCampo\" name=\"$nome\"  placeholder=\"$placeholder\" $required >$valore</textarea>";
                if($etichetta != strip_tags($etichetta)) { // $etichetta contiene html
                    echo $etichetta;
                }
                else { // $etichetta non contiene html quindi fa solo domande
                    echo"<label for=\"$idCampo\">$etichetta</label>";
                }
            echo"</div>";
	}
        
        /*
         * metodo che stampa un campo input di tipo email
         * prende in input i seguenti parametri:
         * 
         * $idCampo         -> id del campo input
         * $nome            -> id del campo input
         * $etichetta           -> label del campo input. Se la stringa passata contiene tag html verrà stampata
                               senza aggiungere codice, altrimenti la stringa verrà stampata dentro il tag <label></label>
         * $placeholder     -> contiene il valore da mettere nella proprietà placeholder del campo input
         * $valore          -> contiene il valore da mettere nella proprietà value
	  * $required        -> campo opzionale che consente di stabilire se il campo è obbligatorio oppure no. Se si vuole
	  *			   rendere quel campo obbligatorio bisogna scrivere required, altrimenti non è necessario impostare il parametro
         * $classeDivContenitore -> campo opzionale che permette di modificare il la classe del div contenitore del form
         *                          se non specificato, ha valore "form-line"
         */
        public static function stampaInputEmail($idCampo,$nome,$etichetta,$placeholder, $valore, $required="", $classeDivContenitore="form-line") {
            echo"<div class=\"$classeDivContenitore\">";
                echo"<input type=\"email\" class=\"form-control\" id=\"$idCampo\" name=\"$nome\" value=\"$valore\" placeholder=\"$placeholder\" $required >";
                if($etichetta != strip_tags($etichetta)) { // $etichetta contiene html
                    echo $etichetta;
                }
                else { // $etichetta non contiene html quindi fa solo domande
                    echo"<label for=\"$idCampo\" >$etichetta</label>";
                }
            echo"</div>";	
	}

        /*
         * metodo che stampa un campo input di tipo email
         * prende in input i seguenti parametri:
         * 
         * $idCampo         -> id del campo input
         * $nome            -> id del campo input
         * $etichetta           -> label del campo input. Se la stringa passata contiene tag html verrà stampata
                               senza aggiungere codice, altrimenti la stringa verrà stampata dentro il tag <label></label>
         * $placeholder     -> contiene il valore da mettere nella proprietà placeholder del campo input
         * $valore          -> contiene il valore da mettere nella proprietà value
	  * $required        -> campo opzionale che consente di stabilire se il campo è obbligatorio oppure no. Se si vuole
	  *			   rendere quel campo obbligatorio bisogna scrivere required, altrimenti non è necessario impostare il parametro
         * $classeDivContenitore -> campo opzionale che permette di modificare il la classe del div contenitore del form
         *                          se non specificato, ha valore "form-line"
         */
        public static function stampaInputPassword($idCampo,$nome,$etichetta,$placeholder,$valore,$required="",$classeDivContenitore="form-line") {
            echo"<div class=\"form-label-group\">";
            if($etichetta != strip_tags($etichetta)) { // $etichetta contiene html
                echo $etichetta;
            }
            else { // $etichetta non contiene html quindi fa solo domande
                echo"<label for=\"$idCampo\" class=\"col-sm-3 control-label\">$etichetta</label>";
            }
            echo"<div class=\"$classeDivContenitore\">
              <input type=\"password\" class=\"form-control\" id=\"$idCampo\" name=\"$nome\" value=\"$valore\" placeholder=\"$placeholder\" $required >
            </div>
          </div>";	
	}
        
        public static function stampaInputNascosto($nome,$valore) {
            echo"<input type=\"text\" class=\"d-none\" name=\"$nome\" value=$valore >";	
	}
        
        public static function stampaInputCheckbox($idCampo,$nome,$etichetta,$valore,$classeDivContenitore, $classeInput, $stringaRequired="") {
            echo"<div class=\"$classeDivContenitore\">
                    <input type=\"checkbox\" id=\"$idCampo\" class=\"$classeInput\" name=\"$nome\" value=\"$valore\" $stringaRequired> 
                    <label for=\"$idCampo\" class=\"custom-control-label\">$etichetta</label>
                </div>";	
	}
	
	public static function stampaInputRadio($message) {
            echo"<div class=\"alert alert-success\">
                <a href=\"#\" class=\"close\" data-dismiss=\"alert\" aria-label=\"close\">&times;</a>
                <span>
                $message </span>
            </div>";	
	}
        
        public static function stampaInputFile($idCampo,$nome,$etichetta) {
            echo"<div class=\"form-group\">
            <label for=\"$idCampo\" class=\"col-sm-3 control-label\">$etichetta</label>
            <div class=\"col-sm-9\">
            <input type=\"file\" id=\"$idCampo\" name=\"$nome\">
            </div>
          </div>";	
	}
        
        /*
         * il campo $opzioni è un array associativo
         */
        public static function stampaSelect($idCampo,$nome,$etichetta,$opzioni,$voceSelezionata,$mostraDivContenitore=true,$classeDivContenitore="form-line") {
        	if($mostraDivContenitore) {
		    echo"<div class=\"$classeDivContenitore\">";
        	}
        	
        	if($etichetta!="") {
			if($etichetta != strip_tags($etichetta)) { // $etichetta contiene html
			    echo $etichetta;
			}
			else { // $etichetta non contiene html quindi fa solo domande
			    echo"<label for=\"$idCampo\" >$etichetta</label>";
			}
        	}
            echo"<select class=\"form-control\" id=\"$idCampo\" name=\"$nome\">";

        	foreach($opzioni as $opzione) {
                    if($opzione =="$voceSelezionata") {
                        $selezionato  = "selected";
                    }
                    else {
                        $selezionato  = "";
                    }
                    echo"<option value=\"$opzione\" $selezionato > $opzione </option>";
        	}

        	echo"</select>";
        	if($mostraDivContenitore) {
		    echo"</div>";
        	}
        }
        
        /*
         * metodo che stampa un campo input di tipo date
         * prende in input i seguenti parametri:
         * 
         * $idCampo         -> id del campo input
         * $nome            -> id del campo input
         * $etichetta           -> label del campo input. Se la stringa passata contiene tag html verrà stampata
                               senza aggiungere codice, altrimenti la stringa verrà stampata dentro il tag <label></label>
         * $placeholder     -> contiene il valore da mettere nella proprietà placeholder del campo input
         * $valore          -> contiene il valore da mettere nella proprietà value
	  * $required        -> campo opzionale che consente di stabilire se il campo è obbligatorio oppure no. Se si vuole
	  *			   rendere quel campo obbligatorio bisogna scrivere required, altrimenti non è necessario impostare il parametro
         * $classeDivContenitore -> campo opzionale che permette di modificare il la classe del div contenitore del form
         *                          se non specificato, ha valore "form-line"
         */
        public static function stampaInputData($idCampo,$nome,$etichetta,$placeholder, $valore, $required="", $classeDivContenitore="form-line") {
            echo"<div class=\"$classeDivContenitore\">";
                echo"<input type=\"date\" class=\"form-control\" id=\"$idCampo\" name=\"$nome\" value=\"$valore\" placeholder=\"$placeholder\" $required >";
                if($etichetta != strip_tags($etichetta)) { // $etichetta contiene html
                    echo $etichetta;
                }
                else { // $etichetta non contiene html quindi fa solo domande
                    echo"<label for=\"$idCampo\" >$etichetta</label>";
                }
            echo"</div>";	
	}
        
        /*
         * metodo che stampa un campo input di tipo time (ovvero l'ora)
         * prende in input i seguenti parametri:
         * 
         * $idCampo         -> id del campo input
         * $nome            -> id del campo input
         * $etichetta           -> label del campo input. Se la stringa passata contiene tag html verrà stampata
                               senza aggiungere codice, altrimenti la stringa verrà stampata dentro il tag <label></label>
         * $placeholder     -> contiene il valore da mettere nella proprietà placeholder del campo input
         * $valore          -> contiene il valore da mettere nella proprietà value
	  * $required        -> campo opzionale che consente di stabilire se il campo è obbligatorio oppure no. Se si vuole
	  *			   rendere quel campo obbligatorio bisogna scrivere required, altrimenti non è necessario impostare il parametro
         * $classeDivContenitore -> campo opzionale che permette di modificare il la classe del div contenitore del form
         *                          se non specificato, ha valore "form-line"
         */
        public static function stampaInputOrario($idCampo,$nome,$etichetta,$placeholder, $valore, $required="", $classeDivContenitore="form-line") {
            echo"<div class=\"$classeDivContenitore\">";
                echo"<input type=\"time\" class=\"form-control\" id=\"$idCampo\" name=\"$nome\" value=\"$valore\" placeholder=\"$placeholder\" $required >";
                if($etichetta != strip_tags($etichetta)) { // $etichetta contiene html
                    echo $etichetta;
                }
                else { // $etichetta non contiene html quindi fa solo domande
                    echo"<label for=\"$idCampo\" >$etichetta</label>";
                }
            echo"</div>";	
	}
    }